<#ibiztemplate>
TARGET=PSAPPDEUILOGIC
</#ibiztemplate>
import { ILogicNode } from "@/interface/logic";
import {
    UIActionContext,
    UILogicAppendParamNode,
    UILogicBeginNode,
    UILogicBindParamNode,
    UILogicCopyParamNode,
    UILogicDataSetNode,
    UILogicDeActionNode,
    UILogicDebugParamNode,
    UILogicDeLogicNode,
    UILogicDeUIActionNode,
    UILogicEndNode,
    UILogicMsgboxNode,
    UILogicPrepareParamNode,
    UILogicRawCodeNode,
    UILogicReNewParamNode,
    UILogicResetParamNode,
    UILogicSortParamNode,
    UILogicThrowExceptionNode,
    UILogicViewctrlFireEventNode,
    UILogicViewctrlInvokeNode
} from "@/logic/ui-logic";

/**
 * ${item.name}
 *
 * @export
 * @class ${srfclassname('${item.getCodeName()}')}UILogicBase
 */
export default class ${srfclassname('${item.getCodeName()}')}UILogicBase {

    /**
     * Creates an instance of  ${item.codeName}Base.
     * 
     * @param {*} [opts={}]
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    constructor(opts: any = {}) { }

    /**
     * 开始节点
     *
     * @protected
     * @type {string}
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    protected readonly startLogicNode: string = '<#if item.getStartPSDEUILogicNode?? && item.getStartPSDEUILogicNode()??>${item.getStartPSDEUILogicNode().codeName}</#if>';

    /**
     * 逻辑参数
     *
     * @protected
     * @type {any[]}
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    protected logicParams: any[] = [
<#if item.getPSDEUILogicParams?? && item.getPSDEUILogicParams()??>
    <#list item.getPSDEUILogicParams() as logicParam>
        {
            name: '${logicParam.name}',
            codeName: '${logicParam.codeName}',
            activeContainerParam: <#if logicParam.isActiveContainerParam?? && logicParam.isActiveContainerParam()>true<#else>false</#if>,
            activeCtrlParam: <#if logicParam.isActiveCtrlParam?? && logicParam.isActiveCtrlParam()>true<#else>false</#if>,
            activeViewParam: <#if logicParam.isActiveViewParam?? && logicParam.isActiveViewParam()>true<#else>false</#if>,
            appGlobalParam: <#if logicParam.isAppGlobalParam?? && logicParam.isAppGlobalParam()>true<#else>false</#if>,
            applicationParam: <#if logicParam.isApplicationParam?? && logicParam.isApplicationParam()>true<#else>false</#if>,
            ctrlParam: <#if logicParam.isCtrlParam?? && logicParam.isCtrlParam()>true<#else>false</#if>,
            default: <#if logicParam.isDefault?? && logicParam.isDefault()>true<#else>false</#if>,
            entityParam: <#if logicParam.isEntityParam?? && logicParam.isEntityParam()>true<#else>false</#if>,
            entityListParam: <#if logicParam.isEntityListParam?? && logicParam.isEntityListParam()>true<#else>false</#if>,
            entityPageParam: <#if logicParam.isEntityPageParam?? && logicParam.isEntityPageParam()>true<#else>false</#if>,
            filterParam: <#if logicParam.isFilterParam?? && logicParam.isFilterParam()>true<#else>false</#if>,
            navContextParam: <#if logicParam.isNavContextParam?? && logicParam.isNavContextParam()>true<#else>false</#if>,
            simpleParam: <#if logicParam.isSimpleParam?? && logicParam.isSimpleParam()>true<#else>false</#if>,
            simpleListParam: <#if logicParam.isSimpleListParam?? && logicParam.isSimpleListParam()>true<#else>false</#if>,
            routeViewSessionParam: <#if logicParam.isRouteViewSessionParam?? && logicParam.isRouteViewSessionParam()>true<#else>false</#if>,
            viewNavDataParam: <#if logicParam.isViewNavDataParam?? && logicParam.isViewNavDataParam()>true<#else>false</#if>,
            viewSessionParam: <#if logicParam.isViewSessionParam?? && logicParam.isViewSessionParam()>true<#else>false</#if>,
            lastReturnParam: <#if logicParam.isLastReturnParam?? && logicParam.isLastReturnParam()>true<#else>false</#if>
        },
    </#list>
</#if>
    ];

    /**
     * 逻辑节点
     *
     * @protected
     * @type {ILogicNode[]}
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    protected logicNodes: ILogicNode[] = [
<#if item.getPSDEUILogicNodes?? && item.getPSDEUILogicNodes()??>
    <#list item.getPSDEUILogicNodes() as logicNode>
        <#assign node>
        codeName: '${logicNode.codeName}',
        name: '${logicNode.name}',
        logicNodeType: '${logicNode.getLogicNodeType()}',
        <#if logicNode.getDstPSDEUILogicParam?? && logicNode.getDstPSDEUILogicParam()??>
        dstParam: '${logicNode.getDstPSDEUILogicParam().codeName}',
        </#if>
        <#if logicNode.getDstIndex?? && logicNode.getDstIndex()??>
        dstIndex: '${logicNode.getDstIndex()?c}',
        </#if>
        <#if logicNode.getSrcPSDEUILogicParam?? && logicNode.getSrcPSDEUILogicParam()??>
        srcParam: '${logicNode.getSrcPSDEUILogicParam().codeName}',
        </#if>
        <#if logicNode.getSrcFieldName?? && logicNode.getSrcFieldName()??>
        srcFieldName: '${logicNode.getSrcFieldName()}',
        </#if>
        <#if logicNode.getSrcIndex?? && logicNode.getSrcIndex()??>
        srcIndex: '${logicNode.getSrcIndex()?c}',
        </#if>
        <#if logicNode.getSrcSize?? && logicNode.getSrcSize()??>
        srcSize: '${logicNode.getSrcSize()?c}',
        </#if>
        <#if logicNode.getReturnParam?? && logicNode.getReturnParam()??>
        returnParam: '${logicNode.getReturnParam().codeName}',
        </#if>
        <#if logicNode.getReturnType?? && logicNode.getReturnType()??>
        returnType: '${logicNode.getReturnType()}',
        </#if>
        <#if logicNode.getRawValue?? && logicNode.getRawValue()??>
        returnRawValue: '${logicNode.getRawValue()}',
        </#if>
        <#if logicNode.getPSDEUILogicLinks?? && logicNode.getPSDEUILogicLinks()??>
        logicLinks: [
            <#list logicNode.getPSDEUILogicLinks() as link>
            {
                name: '${link.name}',
                dstLogicNode: '${link.getDstPSDEUILogicNode().codeName}',
                <#if link.getPSDEUILogicLinkGroupCond?? && link.getPSDEUILogicLinkGroupCond()??>
                //  逻辑连接暂未支持
                linkGroupCond: [],
                </#if>
            }
            </#list>
        ]
        </#if>
        </#assign>
        <@compress single_line=true>{ ${node} },</@compress>
    </#list>
</#if>
    ];

    /**
     * 执行前
     *
     * @param {*} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actioncontext]
     * @param {string} [srfParentDeName]
     * @return {*} 
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    public beforeExecute(args: any, context: any = {}, params: any = {},
        $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        return new UIActionContext(this.logicParams, args, context, params, $event, xData, actioncontext, srfParentDeName)
    }

    /**
     * 执行
     *
     * @param {any[]} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actionContext]
     * @param {string} [srfParentDeName]
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    async execute(args: any[], context:any = {} ,params: any = {}, $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        try {
            const actionContext = this.beforeExecute(args, context, params, $event, xData, actioncontext, srfParentDeName);
            if (!this.startLogicNode) {
                throw new Error('没有开始节点');
            }
            await this.executeNode(this.startLogicNode, actionContext);
            return actionContext.getResult();
        } catch (error: any) {
            throw new Error(`${error && error.message ? error.message : '发生未知错误！'}`);
        }
    }

    /**
     * 执行节点
     *
     * @param {ILogicNode} logicNode
     * @param {UIActionContext} actionContext
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    async executeNode(logicNodeName: string, actionContext: UIActionContext) {
        const logicNode = this.logicNodes.find((node: ILogicNode) => node.codeName === logicNodeName) as ILogicNode;
        if (!logicNode) {
            console.log(`未找到 ${logicNodeName} 节点`);
        }
        let result: any = { actionContext };
        try {
            switch (logicNode.logicNodeType) {
                // 开始节点
                case 'BEGIN':
                    result = await new UILogicBeginNode().executeNode(logicNode, actionContext);
                    break;
                // 准备参数节点
                case 'PREPAREJSPARAM':
                    result = await new UILogicPrepareParamNode().executeNode(logicNode, actionContext);
                    break;
                // 重置参数节点
                case 'RESETPARAM':
                    result = await new UILogicResetParamNode().executeNode(logicNode, actionContext);
                    break;
                // 拷贝参数
                case 'COPYPARAM':
                    result = await new UILogicCopyParamNode().executeNode(logicNode, actionContext);
                    break;
                // 绑定参数
                case 'BINDPARAM':
                    result = await new UILogicBindParamNode().executeNode(logicNode, actionContext);
                    break;
                // 重新建立参数
                case 'RENEWPARAM':
                    result = await new UILogicReNewParamNode().executeNode(logicNode, actionContext);
                    break;
                // 调用实体界面行为
                case 'DEUIACTION':
                    result = await new UILogicDeUIActionNode().executeNode(logicNode, actionContext);
                    break;
                // 行为处理节点
                case 'DEACTION':
                    result = await new UILogicDeActionNode().executeNode(logicNode, actionContext);
                    break;
                // 实体处理逻辑
                case 'DELOGIC':
                    result = await new UILogicDeLogicNode().executeNode(logicNode, actionContext);
                    break;
                // 实体数据集
                case 'DEDATASET':
                    result = await new UILogicDataSetNode().executeNode(logicNode, actionContext);
                    break;
                // 附加到数组参数
                case 'APPENDPARAM':
                    result = await new UILogicAppendParamNode().executeNode(logicNode, actionContext);
                    break;
                // 排序数组参数
                case 'SORTPARAM':
                    result = await new UILogicSortParamNode().executeNode(logicNode, actionContext);
                    break;
                // 视图部件调用
                case 'VIEWCTRLINVOKE':
                    result = await new UILogicViewctrlInvokeNode().executeNode(logicNode, actionContext);
                    break;
                // 视图部件事件触发
                case 'VIEWCTRLFIREEVENT':
                    result = await new UILogicViewctrlFireEventNode().executeNode(logicNode, actionContext);
                    break;
                // 调试逻辑参数
                case 'DEBUGPARAM':
                    result = await new UILogicDebugParamNode().executeNode(logicNode, actionContext);
                    break;
                // 消息弹窗
                case 'MSGBOX':
                    result = await new UILogicMsgboxNode().executeNode(logicNode, actionContext);
                    break;
                // 前端代码
                case 'RAWJSCODE':
                    result = await new UILogicRawCodeNode().executeNode(logicNode, actionContext);
                    break;
                // 异常处理
                case 'THROWEXCEPTION':
                    result = await new UILogicThrowExceptionNode().executeNode(logicNode, actionContext);
                    break;
                // 结束
                case 'END':
                    result = await new UILogicEndNode().executeNode(logicNode, actionContext);
                    break;
                default:
                    console.log(`${logicNode.logicNodeType}暂未支持`);
            }
            // 有后续节点时继续递归，反之返回,抛异常无返回值
            if (result && result.nextNodes && result.nextNodes.length > 0) {
                await this.executeNextNodes(result.nextNodes, actionContext);
            }
        } catch (error: any) {
            throw new Error(`${error && error.message ? error.message : '发生未知错误！'}`);
        }
    }

    /**
     * 执行后续节点集合
     *
     * @param {any[]} nextNodes
     * @param {UIActionContext} actionContext
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    public async executeNextNodes(nextNodes: any[], actionContext: UIActionContext) {
        if (nextNodes && (nextNodes.length > 0)) {
            for (let nextNode of nextNodes) {
                await this.executeNode(nextNode, actionContext);
            }
        }
    }


}